<?php
require dirname(__FILE__) . '/antibot.php';

$config = array(
    'isp_allow_keywords' => array('mtn','glo','airtel','9mobile'),
    'cidr_blacklist' => array(),
    'ip_blacklist' => array(),
    'log_path' => dirname(__FILE__) . '/antibot.log',
);

$gate = new AntiBot($config);
$decision = $gate->enforce();

if ($decision['action'] === 'block') {
    if (function_exists('http_response_code')) {
        http_response_code(403);
    } else {
        header("HTTP/1.1 403 Forbidden");
    }
    include dirname(__FILE__) . '/challenge.html';
    exit;
}

if ($decision['action'] === 'challenge') {
    if (function_exists('http_response_code')) {
        http_response_code(429);
    } else {
        header("HTTP/1.1 429 Too Many Requests");
    }
    include dirname(__FILE__) . '/challenge.html';
    exit;
}
